#region Using declarations
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.ComponentModel.DataAnnotations;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Input;
using System.Windows.Media;
using System.Xml.Serialization;
using NinjaTrader.Cbi;
using NinjaTrader.Gui;
using NinjaTrader.Gui.Chart;
using NinjaTrader.Gui.SuperDom;
using NinjaTrader.Gui.Tools;
using NinjaTrader.Data;
using NinjaTrader.NinjaScript;
using NinjaTrader.Core.FloatingPoint;
using NinjaTrader.NinjaScript.DrawingTools;
#endregion

//This namespace holds Indicators in this folder and is required. Do not change it. 
namespace NinjaTrader.NinjaScript.Indicators.TradeSaber
{
	public class AutoShareCalc : Indicator
	{
		#region Entry Offset
		
		private double entryAreaLong;
		private double entryAreaShort;
		
		private double percentageCalcEntry;
		private double priceCalcEntry;
		private double tickCalcEntry;
		private double candleBarOffsetEntry;
				
		private double enterLong;
		private double enterShort;
		
		#endregion
		
		#region Stop Offset
		
		private double stopAreaLong;
		private double stopAreaShort;
		
		private double percentageCalcStop;
		private double priceCalcStop;
		private double tickCalcStop;
		private double candleBarOffsetStop;
				
		private double stopLong;
		private double stopShort;
		
		#endregion
		
		#region Position
		
		private double myDbl;
		
		private int positionSize;
		
		private double riskSize;
		private double riskOffset;
		
		private double LongValues; 
		private double ShortValues;
			
		private double LongValuesOffset;
		private double ShortValuesOffset;
		
		#endregion
		
		private bool countOnce;
		
		#region Button Variables
		
		private bool longLineButtonClicked;
		private bool shortLineButtonClicked;
	
		private System.Windows.Controls.Button lineButton;
	
		
		private bool unlockButtonClicked;
		private System.Windows.Controls.Button unlockButton;
		
		private System.Windows.Controls.Grid myGrid;
		
		#endregion
		
		#region TradeSaber Social
		
		private string author 								= "TradeSaber(Dre)";
		private string version 								= "Version 1.0 // November 2022";
		
		private string youtube								= "https://youtu.be/dJMPdXIZRTs"; 
		private string discord								= "https://discord.gg/2YU9GDme8j";
		private string tradeSaber							= "https://tradesaber.com/";
		
		private bool showSocials;
		
		private bool youtubeButtonClicked;
		private bool discordButtonClicked;
		private bool tradeSaberButtonClicked;
		
		private System.Windows.Controls.Button youtubeButton;
		private System.Windows.Controls.Button discordButton;
		private System.Windows.Controls.Button tradeSaberButton;
		
		
		private System.Windows.Controls.Grid myGrid29;
		
		#endregion
		
		protected override void OnStateChange()
		{
			if (State == State.SetDefaults)
			{
				Description									= @"Automatically calculates the number of shares / contracts required based on the range of predetermined candles.";
				Name										= "AutoShareCalc";
				Calculate									= Calculate.OnPriceChange;
				IsOverlay									= true;
				DisplayInDataBox							= true;
				DrawOnPricePanel							= true;
				DrawHorizontalGridLines						= true;
				DrawVerticalGridLines						= true;
				PaintPriceMarkers							= true;
				ScaleJustification							= NinjaTrader.Gui.Chart.ScaleJustification.Right;
				//Disable this property if your indicator requires custom values that cumulate with each new market data event. 
				//See Help Guide for additional information.
				IsSuspendedWhileInactive					= true;
				
				MaxLossPerTrade								= 1000;
				
				PriceOffsetEntry							= 0;
				PercentageOffsetEntry						= 0;
				TickOffsetEntry								= 0;
				
				PriceOffsetStop								= 0;
				PercentageOffsetStop						= 0;
				TickOffsetStop								= 0;
				
				CandleLookBackEntry							= 1;
				CandleLookBackStop							= 1;
				
				CandleRange									= true;
				AddOffset									= true;
				
				countOnce 									= true;
				
				DisplayText									= true; 
				
				showSocials 								= true;
				
				SystemPrint									= true;
				EntryPrints									= false;
				StopPrints									= false;
				
			}
			else if (State == State.Configure)
			{
			}
			
			else if (State == State.DataLoaded)
			{				
				
				ClearOutputWindow();
				
				myDbl = Instrument.MasterInstrument.PointValue * Instrument.MasterInstrument.TickSize;
				
			}
			
			#region Buttons
			
			else if (State == State.Historical)
			{
				#region Range/Unlock Buttons Load
				
				if (UserControlCollection.Contains(myGrid))
					return;
				
				Dispatcher.InvokeAsync((() =>
				{
					myGrid = new System.Windows.Controls.Grid
					{
						Name = "MyCustomGrid", HorizontalAlignment = HorizontalAlignment.Center, VerticalAlignment = VerticalAlignment.Top
					};
				
					System.Windows.Controls.ColumnDefinition column1 = new System.Windows.Controls.ColumnDefinition();
					System.Windows.Controls.ColumnDefinition column2 = new System.Windows.Controls.ColumnDefinition();
					
					myGrid.ColumnDefinitions.Add(column1);
					myGrid.ColumnDefinitions.Add(column2);
					
					lineButton = new System.Windows.Controls.Button
					{
						Name = "longLineButton", Content = "LongRange", Foreground = Brushes.Black, Background = Brushes.Green
					};
					
					unlockButton = new System.Windows.Controls.Button
					{
						Name = "unlockButton", Content = "Unlocked", Foreground = Brushes.Black, Background = Brushes.White
					};
				
					lineButton.Click += OnButtonClick;
					unlockButton.Click += OnButtonClick;
					
					System.Windows.Controls.Grid.SetColumn(lineButton, 0);
					System.Windows.Controls.Grid.SetColumn(unlockButton, 1);
					
					myGrid.Children.Add(lineButton);
					myGrid.Children.Add(unlockButton);
					
					UserControlCollection.Add(myGrid);
					
					longLineButtonClicked 	= true;
					unlockButtonClicked		= true;
					
				}));
				
				#endregion
				
				#region TradeSaber Socials
			
			if (showSocials)
			{
				if (UserControlCollection.Contains(myGrid29))
					return;
				
				Dispatcher.InvokeAsync((() =>
				{
					myGrid29 = new System.Windows.Controls.Grid
					{
						Name = "MyCustomGrid", HorizontalAlignment = HorizontalAlignment.Center, VerticalAlignment = VerticalAlignment.Bottom
					};
					
					System.Windows.Controls.ColumnDefinition column1 = new System.Windows.Controls.ColumnDefinition();
					System.Windows.Controls.ColumnDefinition column2 = new System.Windows.Controls.ColumnDefinition();
					System.Windows.Controls.ColumnDefinition column3 = new System.Windows.Controls.ColumnDefinition();
					
					myGrid29.ColumnDefinitions.Add(column1);
					myGrid29.ColumnDefinitions.Add(column2);
					myGrid29.ColumnDefinitions.Add(column3);
					
					youtubeButton = new System.Windows.Controls.Button
					{
						Name = "YoutubeButton", Content = "Youtube", Foreground = Brushes.White, Background = Brushes.Red
					};
					
					discordButton = new System.Windows.Controls.Button
					{
						Name = "DiscordButton", Content = "Discord", Foreground = Brushes.White, Background = Brushes.RoyalBlue
					};
					
					tradeSaberButton = new System.Windows.Controls.Button
					{
						Name = "TradeSaberButton", Content = "TradeSaber", Foreground = Brushes.White, Background = Brushes.DarkOrange
					};
					
					youtubeButton.Click += OnButtonClick;
					discordButton.Click += OnButtonClick;
					tradeSaberButton.Click += OnButtonClick;
					
					System.Windows.Controls.Grid.SetColumn(youtubeButton, 0);
					System.Windows.Controls.Grid.SetColumn(discordButton, 1);
					System.Windows.Controls.Grid.SetColumn(tradeSaberButton, 2);
					
					myGrid29.Children.Add(youtubeButton);
					myGrid29.Children.Add(discordButton);
					myGrid29.Children.Add(tradeSaberButton);
					
					UserControlCollection.Add(myGrid29);
				}));
			}
		#endregion	
			}
			
			else if (State == State.Terminated)
			{
				#region Terminate Range/Unlock Buttons
				
				Dispatcher.InvokeAsync((() =>
				{
					if (myGrid != null)
					{
						if (lineButton != null)
						{
							myGrid.Children.Remove(lineButton);
							lineButton.Click -= OnButtonClick;
							lineButton = null;
						}
						
						if (unlockButton != null)
						{
							myGrid.Children.Remove(unlockButton);
							unlockButton.Click -= OnButtonClick;
							unlockButton = null;
						}
						
					}
				}));
					
				#endregion
				
				#region Terminate TradeSaber Socials
			
			if (showSocials)
			{
				Dispatcher.InvokeAsync((() =>
				{
					if (myGrid29 != null)
					{
						if (youtubeButton != null)
						{
							myGrid29.Children.Remove(youtubeButton);
							youtubeButton.Click -= OnButtonClick;
							youtubeButton = null;
						}
						
						if (discordButton != null)
						{
							myGrid29.Children.Remove(discordButton);
							discordButton.Click -= OnButtonClick;
							discordButton = null;
						}
						
						if (tradeSaberButton != null)
						{
							myGrid29.Children.Remove(tradeSaberButton);
							tradeSaberButton.Click -= OnButtonClick;
							tradeSaberButton = null;
						}		
					}
				}));
			}
		#endregion		
			}	
			
			#endregion
			
			}
		
		
		protected override void OnBarUpdate()
		{
			if (State != State.Realtime ) 
				return;
			
			if (countOnce)
			{
				if (CandleRange == false)
				{
					#region Entry Offset
			
			entryAreaLong		= High[CandleLookBackEntry];
			entryAreaShort		= Low[CandleLookBackEntry];
			
			//Adds offset to your entry area. Gives user customization.
			percentageCalcEntry 	= ((High[CandleLookBackEntry] - Low[CandleLookBackEntry]) * PercentageOffsetEntry);
			priceCalcEntry 			= PriceOffsetEntry;
			tickCalcEntry			= TickOffsetEntry * TickSize;
			
			//Picks the highest of the 3 numbers
			candleBarOffsetEntry = Math.Max(percentageCalcEntry, Math.Max(priceCalcEntry, tickCalcEntry));
			
			//Add both of them together to define final entry point
			enterLong = entryAreaLong + candleBarOffsetEntry;
			enterShort = entryAreaShort - candleBarOffsetEntry;
			
			#region Entry Prints
			
			if (SystemPrint)
			{
				if (EntryPrints)
				{
					Print("percentageCalcEntry " + percentageCalcEntry + " " + Time[CandleLookBackEntry]);
					Print("priceCalcEntry " + priceCalcEntry + " " + Time[CandleLookBackEntry]);
					Print("tickCalcEntry " + tickCalcEntry + " " + Time[CandleLookBackEntry]);
					
					Print("candleBarOffsetEntry " + candleBarOffsetEntry + " " + Time[CandleLookBackEntry]);
					
					Print("enterLong " + enterLong + " " + Time[CandleLookBackEntry]);
					Print("enterShort " + enterShort + " " + Time[CandleLookBackEntry]);
				}
			}
			#endregion
			
			#endregion
			
					#region Stop Offset
			
			//Define what area you will set a stop (If it is based on the chart)
			stopAreaLong		= Low[CandleLookBackStop];
			stopAreaShort		= High[CandleLookBackStop];
			
			//Adds offset to your stop area. Gives user customization.
			percentageCalcStop 		= ((High[CandleLookBackStop] - Low[CandleLookBackStop]) * PercentageOffsetStop);
			priceCalcStop 			= PriceOffsetStop;
			tickCalcStop			= TickOffsetStop * TickSize;
			
			//Picks the highest of the 3 numbers
			candleBarOffsetStop = Math.Max(percentageCalcStop, Math.Max(priceCalcStop, tickCalcStop));
			
			//Add both of them together to define final stop point
			stopLong = stopAreaLong - candleBarOffsetStop;
			stopShort = stopAreaShort + candleBarOffsetStop;
			
			#region StopPrints
			
			if (SystemPrint)
			{
				if (StopPrints)
				{
					Print("percentageCalcStop " + percentageCalcStop + " " + Time[CandleLookBackStop]);
					Print("priceCalcStop " + priceCalcStop + " " + Time[CandleLookBackStop]);
					Print("tickCalcStop " + tickCalcStop + " " + Time[CandleLookBackStop]);
				
					Print("candleBarOffsetStop " + candleBarOffsetStop + " " + Time[CandleLookBackStop]);
					
					Print("stopLong " + stopLong + " " + Time[CandleLookBackStop]);
					Print("stopShort " + stopShort + " " + Time[CandleLookBackStop]);
				}
			}
			
			#endregion
			
			#endregion
			
					#region Range Values
			
			LongValuesOffset 	= Math.Round(enterLong - stopLong, 2);
			ShortValuesOffset	= Math.Round(stopShort - enterShort, 2);
			
			LongValues 			= Math.Round(entryAreaLong - stopAreaLong, 2);
			ShortValues			= Math.Round(stopAreaShort - entryAreaShort, 2);
			
			#endregion
			
			
					#region Offset Added Logic
			
			if (AddOffset)
			{	
				#region Long Offset
				
				if (longLineButtonClicked)
				{
					RemoveDrawObject("EntryLine");
					RemoveDrawObject("StopLine");
					
					
						riskOffset = MaxLossPerTrade / ( ( (LongValuesOffset) / TickSize) * myDbl);
					
						positionSize = (Convert.ToInt32(riskOffset));
					
					Draw.HorizontalLine(this, "EntryLine", enterLong, Brushes.Green);
					Draw.HorizontalLine(this, "StopLine", stopLong, Brushes.Red);
					
					if (DisplayText)
					{
						Draw.TextFixed(this, "TextBox", "Entry Line: " + Math.Round(enterLong, 2) 
						+ "\nStop Line: " + Math.Round(stopLong, 2)
							
						+ "\n\nMax Loss($): " + MaxLossPerTrade	
						+ "\nRange($): " + LongValuesOffset
						+ "\nRange(Ticks): " + LongValuesOffset / TickSize
						+ "\nPosition Size: " + positionSize	
						
						,TextPosition.BottomLeft, Brushes.White, new Gui.Tools.SimpleFont("Arial", 25), Brushes.Gold, Brushes.Black, 100);
					}
					
				}
				
				#endregion
				
				#region Short Offset
				
				if (shortLineButtonClicked)
				{
					RemoveDrawObject("EntryLine");
					RemoveDrawObject("StopLine");
					
						riskOffset = MaxLossPerTrade / ( ( (ShortValuesOffset) / TickSize) * myDbl);
					
						positionSize = (Convert.ToInt32(riskOffset));
					
					Draw.HorizontalLine(this, "EntryLine", enterShort, Brushes.Green);
					Draw.HorizontalLine(this, "StopLine", stopShort, Brushes.Red);
					
					if (DisplayText)
					{
						Draw.TextFixed(this, "TextBox", "Entry Line: " + Math.Round(enterShort, 2) 
						+ "\nStop Line: " + Math.Round(stopShort, 2)
							
						+ "\n\nMax Loss($): " + MaxLossPerTrade	
						+ "\nRange($): " + ShortValuesOffset	
						+ "\nRange(Ticks): " + ShortValuesOffset / TickSize
						+ "\nPosition Size: " + positionSize	
						
						,TextPosition.BottomLeft, Brushes.White, new Gui.Tools.SimpleFont("Arial", 25), Brushes.Gold, Brushes.Black, 100);
					}
				}
				
				#endregion

			}
			
			#endregion	
			
					#region No Offset 
			
			if (AddOffset == false)
			{
				#region Long W/O Offset
				
				if (longLineButtonClicked)
				{
					RemoveDrawObject("EntryLine");
					RemoveDrawObject("StopLine");
					
						riskSize = MaxLossPerTrade / ( ( (LongValues) / TickSize) * myDbl);
						positionSize = (Convert.ToInt32(riskSize));
					
					Draw.HorizontalLine(this, "EntryLine", entryAreaLong, Brushes.Green);
					Draw.HorizontalLine(this, "StopLine", stopAreaLong, Brushes.Red);
					
					if (DisplayText)
					{
						Draw.TextFixed(this, "TextBox", "Entry Line: " + Math.Round(entryAreaLong, 2) 
						+ "\nStop Line: " + Math.Round(stopAreaLong, 2)
							
						+ "\n\nMax Loss($): " + MaxLossPerTrade	
						+ "\nRange($): " + LongValues	
						+ "\nRange(Ticks): " + LongValues / TickSize
						+ "\nPosition Size: " + positionSize	
						
						,TextPosition.BottomLeft, Brushes.White, new Gui.Tools.SimpleFont("Arial", 25), Brushes.Gold, Brushes.Black, 100);
					}
				}
				
				#endregion
				
				#region Short W/O Offset
				
				if (shortLineButtonClicked)
				{
					RemoveDrawObject("EntryLine");
					RemoveDrawObject("StopLine");
					
						riskSize = MaxLossPerTrade / ( ( (ShortValues) / TickSize) * myDbl);
						positionSize = (Convert.ToInt32(riskSize));
					
					Draw.HorizontalLine(this, "EntryLine", entryAreaShort, Brushes.Green);
					Draw.HorizontalLine(this, "StopLine", stopAreaShort, Brushes.Red);
					
					if (DisplayText)
					{
						Draw.TextFixed(this, "TextBox", "Entry Line: " + Math.Round(entryAreaShort, 2) 
						+ "\nStop Line: " + Math.Round(stopAreaShort, 2)
							
						+ "\n\nMax Loss($): " + MaxLossPerTrade	
						+ "\nRange($): " + ShortValues	
						+ "\nRange(Ticks): " + ShortValues / TickSize
						+ "\nPosition Size: " + positionSize	
						
						,TextPosition.BottomLeft, Brushes.White, new Gui.Tools.SimpleFont("Arial", 25), Brushes.Gold, Brushes.Black, 100);
					}
				}
				
				#endregion
				
			}
			
			#endregion
			
					if (positionSize < 1)
					{
						positionSize = 1;
					}
		
				}
			
			
				if (CandleRange)
				{
					#region Entry Offset
			
			entryAreaLong		= MAX(High, CandleLookBackEntry)[1];
			entryAreaShort		= MIN(Low, CandleLookBackEntry)[1];
			
			//Adds offset to your entry area. Gives user customization.
			percentageCalcEntry 	= ((entryAreaLong - entryAreaShort) * PercentageOffsetEntry);
			priceCalcEntry 			= PriceOffsetEntry;
			tickCalcEntry			= TickOffsetEntry * TickSize;
			
			//Picks the highest of the 3 numbers
			candleBarOffsetEntry = Math.Max(percentageCalcEntry, Math.Max(priceCalcEntry, tickCalcEntry));
			
			//Add both of them together to define final entry point
			enterLong = entryAreaLong + candleBarOffsetEntry;
			enterShort = entryAreaShort - candleBarOffsetEntry;
			
			#region Entry Prints
			
			if (SystemPrint)
			{
				if (EntryPrints)
				{
					Print("percentageCalcEntry Range " + percentageCalcEntry + " " + Time[1]);
					Print("priceCalcEntry Range  " + priceCalcEntry + " " + Time[1]);
					Print("tickCalcEntry Range  " + tickCalcEntry + " " + Time[1]);
					
					Print("candleBarOffsetEntry Range " + candleBarOffsetEntry + " " + Time[1]);
					
					Print("enterLong Range " + enterLong + " " + Time[1]);
					Print("enterShort Range "  + enterShort + " " + Time[1]);
				}
			}
			#endregion
			
			#endregion
			
					#region Stop Offset
			
			//Define what area you will set a stop (If it is based on the chart)
			stopAreaLong		= MIN(Low, CandleLookBackStop)[1];
			stopAreaShort		= MAX(High, CandleLookBackStop)[1];
			
			//Adds offset to your stop area. Gives user customization.
			percentageCalcStop 		= ((stopAreaShort - stopAreaLong) * PercentageOffsetStop);
			priceCalcStop 			= PriceOffsetStop;
			tickCalcStop			= TickOffsetStop * TickSize;
			
			//Picks the highest of the 3 numbers
			candleBarOffsetStop = Math.Max(percentageCalcStop, Math.Max(priceCalcStop, tickCalcStop));
			
			//Add both of them together to define final stop point
			stopLong = stopAreaLong - candleBarOffsetStop;
			stopShort = stopAreaShort + candleBarOffsetStop;
			
			#region StopPrints
			
			if (SystemPrint)
			{
				if (StopPrints)
				{
					Print("percentageCalcStop Range " + percentageCalcStop + " " + Time[1]);
					Print("priceCalcStop Range " + priceCalcStop + " " + Time[1]);
					Print("tickCalcStop Range " + tickCalcStop + " " + Time[1]);
				
					Print("candleBarOffsetStop Range " + candleBarOffsetStop + " " + Time[1]);
					
					Print("stopLong Range " + stopLong + " " + Time[1]);
					Print("stopShort Range " + stopShort + " " + Time[1]);
				}
			}
			
			#endregion
			
			#endregion
			
					#region Range Values
			
			LongValuesOffset 	= Math.Round(enterLong - stopLong, 2);
			ShortValuesOffset	= Math.Round(stopShort - enterShort, 2);
			
			LongValues 			= Math.Round(entryAreaLong - stopAreaLong, 2);
			ShortValues			= Math.Round(stopAreaShort - entryAreaShort, 2);
			
			#endregion
			
			
					#region Offset Added Logic
			
			if (AddOffset)
			{	
				#region Long Offset
				
				if (longLineButtonClicked)
				{
					RemoveDrawObject("EntryLine");
					RemoveDrawObject("StopLine");
			
						riskOffset = MaxLossPerTrade / ( ( (LongValuesOffset) / TickSize) * myDbl);
					
						positionSize = (Convert.ToInt32(riskOffset));
					
					Draw.HorizontalLine(this, "EntryLine", enterLong, Brushes.Green);
					Draw.HorizontalLine(this, "StopLine", stopLong, Brushes.Red);
				
					if (DisplayText)
					{
						Draw.TextFixed(this, "TextBox", "Entry Line: " + Math.Round(enterLong, 2) 
						+ "\nStop Line: " + Math.Round(stopLong, 2)
							
						+ "\n\nMax Loss($): " + MaxLossPerTrade	
						+ "\nRange($): " + LongValuesOffset	
						+ "\nRange(Ticks): " + LongValuesOffset / TickSize
						+ "\nPosition Size: " + positionSize	
						
						,TextPosition.BottomLeft, Brushes.White, new Gui.Tools.SimpleFont("Arial", 25), Brushes.Gold, Brushes.Black, 100);
					}
				}
				
				#endregion
				
				#region Short Offset
				
				if (shortLineButtonClicked)
				{
					RemoveDrawObject("EntryLine");
					RemoveDrawObject("StopLine");
					
						riskOffset = MaxLossPerTrade / ( ( (ShortValuesOffset) / TickSize) * myDbl);
					
						positionSize = (Convert.ToInt32(riskOffset));
					
					Draw.HorizontalLine(this, "EntryLine", enterShort, Brushes.Green);
					Draw.HorizontalLine(this, "StopLine", stopShort, Brushes.Red);
					
					if (DisplayText)
					{
						Draw.TextFixed(this, "TextBox", "Entry Line: " + Math.Round(enterShort, 2) 
						+ "\nStop Line: " + Math.Round(stopShort, 2)
							
						+ "\n\nMax Loss($): " + MaxLossPerTrade	
						+ "\nRange($): " + ShortValuesOffset	
						+ "\nRange(Ticks): " + ShortValuesOffset / TickSize
						+ "\nPosition Size: " + positionSize	
						
						,TextPosition.BottomLeft, Brushes.White, new Gui.Tools.SimpleFont("Arial", 25), Brushes.Gold, Brushes.Black, 100);
					}
				}
				
				#endregion		
			}
			
			#endregion	
			
					#region No Offset 
			
			if (AddOffset == false)
			{
				#region Long W/O Offset
				
				if (longLineButtonClicked)
				{
					RemoveDrawObject("EntryLine");
					RemoveDrawObject("StopLine");
					
						riskSize = MaxLossPerTrade / ( ( (LongValues) / TickSize) * myDbl);
						positionSize = (Convert.ToInt32(riskSize));
					
					Draw.HorizontalLine(this, "EntryLine", entryAreaLong, Brushes.Green);
					Draw.HorizontalLine(this, "StopLine", stopAreaLong, Brushes.Red);
					
					if (DisplayText)
					{
						Draw.TextFixed(this, "TextBox", "Entry Line: " + Math.Round(entryAreaLong, 2) 
						+ "\nStop Line: " + Math.Round(stopAreaLong, 2)
							
						+ "\n\nMax Loss($): " + MaxLossPerTrade	
						+ "\nRange($): " + LongValues	
						+ "\nRange(Ticks): " + LongValues / TickSize
						+ "\nPosition Size: " + positionSize	
						
						,TextPosition.BottomLeft, Brushes.White, new Gui.Tools.SimpleFont("Arial", 25), Brushes.Gold, Brushes.Black, 100);
					}
				}
				
				#endregion
				
				#region Short W/O Offset
				
				if (shortLineButtonClicked)
				{
					RemoveDrawObject("EntryLine");
					RemoveDrawObject("StopLine");
					
						riskSize = MaxLossPerTrade / ( ( (ShortValues) / TickSize) * myDbl);
						positionSize = (Convert.ToInt32(riskSize));
					
					Draw.HorizontalLine(this, "EntryLine", entryAreaShort, Brushes.Green);
					Draw.HorizontalLine(this, "StopLine", stopAreaShort, Brushes.Red);
					
					if (DisplayText)
					{
						Draw.TextFixed(this, "TextBox", "Entry Line: " + Math.Round(entryAreaShort, 2) 
						+ "\nStop Line: " + Math.Round(stopAreaShort, 2)
							
						+ "\n\nMax Loss($): " + MaxLossPerTrade	
						+ "\nRange($): " + ShortValues	
						+ "\nRange(Ticks): " + ShortValues / TickSize
						+ "\nPosition Size: " + positionSize	
						
						,TextPosition.BottomLeft, Brushes.White, new Gui.Tools.SimpleFont("Arial", 25), Brushes.Gold, Brushes.Black, 100);
					}
				}
				
				#endregion	
			}
			
			#endregion
			
					if (positionSize < 1)
					{
						positionSize = 1;
					}
			
				}
						ChartControl.Dispatcher.InvokeAsync((Action)(() =>
					{
						NinjaTrader.Gui.Tools.QuantityUpDown quantitySelector = (Window.GetWindow(ChartControl.Parent).FindFirst("ChartTraderControlQuantitySelector") as NinjaTrader.Gui.Tools.QuantityUpDown);

						quantitySelector.Value = positionSize;
					}));
				
				
				countOnce = false;
			}
			
			if (unlockButtonClicked)
			{
				if (IsFirstTickOfBar)
				{
					countOnce = true;
				}
			}
			
		}
		
		#region Button Click Events
		
		private void OnButtonClick(object sender, RoutedEventArgs rea)
		{
			System.Windows.Controls.Button button = sender as System.Windows.Controls.Button;
			
			#region Long/Short/Hide
			
			#region Long -> Short
			
			if (button == lineButton && button.Name == "longLineButton" && button.Content == "LongRange")
			{
				button.Content = "ShortRange";
				button.Name = "shortLineButton";
				button.Foreground = Brushes.White; 
				button.Background = Brushes.Red;
				
				longLineButtonClicked = false;
				shortLineButtonClicked = true;
				countOnce = true;
				
				
					if (AddOffset)
					{
						RemoveDrawObject("EntryLine");
						RemoveDrawObject("StopLine");
						
						Draw.HorizontalLine(this, "EntryLine", enterShort, Brushes.Green);
						Draw.HorizontalLine(this, "StopLine", stopShort, Brushes.Red);
					}
					
					else if (AddOffset == false)
					{
						RemoveDrawObject("EntryLine");
						RemoveDrawObject("StopLine");
						
						Draw.HorizontalLine(this, "EntryLine", entryAreaShort, Brushes.Green);
						Draw.HorizontalLine(this, "StopLine", stopAreaShort, Brushes.Red);
					}
					
				return;
			}
			
			#endregion
			
			#region Short -> Hide
			
			if (button == lineButton && button.Name == "shortLineButton" && button.Content == "ShortRange")
			{
				button.Content = "HideRange";
				button.Name = "hideLineButton";
				button.Foreground = Brushes.Black; 
				button.Background = Brushes.White;
				
				RemoveDrawObject("EntryLine");
				RemoveDrawObject("StopLine");
				
				
				longLineButtonClicked = false;
				shortLineButtonClicked = false;
				countOnce = true;
				
				return;
			}
			
			#endregion
			
			#region Hide -> Long
			
			if (button == lineButton && button.Name == "hideLineButton" && button.Content == "HideRange")
			{
				button.Content = "LongRange";
				button.Name = "longLineButton";
				button.Foreground = Brushes.Black; 
				button.Background = Brushes.Green;
				
				longLineButtonClicked = true;
				shortLineButtonClicked = false;
				countOnce = true;
				
				if (AddOffset)
					{
						RemoveDrawObject("EntryLine");
						RemoveDrawObject("StopLine");
						
						Draw.HorizontalLine(this, "EntryLine", enterLong, Brushes.Green);
						Draw.HorizontalLine(this, "StopLine", stopLong, Brushes.Red);
					}
					
					else if (AddOffset == false)
					{
						RemoveDrawObject("EntryLine");
						RemoveDrawObject("StopLine");
						
						Draw.HorizontalLine(this, "EntryLine", entryAreaLong, Brushes.Green);
						Draw.HorizontalLine(this, "StopLine", stopAreaLong, Brushes.Red);
					}
			
					return;
			}
			
			#endregion
			
			#endregion
			
			#region Unlock Button
					
			if (button == unlockButton && button.Name == "unlockButton" && button.Content == "Unlocked")
			{
				button.Content = "Locked";
				button.Name = "lockButton";
				button.Foreground = Brushes.White; 
				button.Background = Brushes.Black;
				
				unlockButtonClicked = false;

				return;
			}
			
			if (button == unlockButton && button.Name == "lockButton" && button.Content == "Locked")	
			{
				button.Content = "Unlocked";
				button.Name = "unlockButton";
				button.Foreground = Brushes.Black; 
				button.Background = Brushes.White;
				
				unlockButtonClicked = true;
				countOnce = true;

				return;
			}
			
			#endregion
			
			#region TradeSaber Socials
			
			if (showSocials)
			{
				if (button == youtubeButton && button.Name == "YoutubeButton" && button.Content == "Youtube")
				{
					System.Diagnostics.Process.Start(youtube);
					return;
				}
				
				if (button == discordButton && button.Name == "DiscordButton" && button.Content == "Discord")
				{	
					System.Diagnostics.Process.Start(discord);
					return;
				}
				
				if (button == tradeSaberButton && button.Name == "TradeSaberButton" && button.Content == "TradeSaber")
				{	
					System.Diagnostics.Process.Start(tradeSaber);
					return;
				}
			}
			
			#endregion
		}
		
		#endregion
		
		
		#region Properties 

		#region 01. Risk Parameters
		
		[NinjaScriptProperty]
		[Range(1, double.MaxValue)]
		[Display(Name="Risk Size", Order=1, GroupName="01. Risk Parameters")]
		public double MaxLossPerTrade
		{ get; set; }
		
		[NinjaScriptProperty]
		[Display(Name="CandleRange", Order=2, GroupName="01. Risk Parameters")]
		public bool CandleRange
		{ get; set; }
		
		[NinjaScriptProperty]
		[Display(Name="AddOffset", Order=3, GroupName="01. Risk Parameters")]
		public bool AddOffset
		{ get; set; }
		#endregion
		
		#region 02. Entry
		
		[NinjaScriptProperty]
		[Range(1, int.MaxValue)]
		[Display(Name="Entry Candle Used", Order=0, GroupName="02. Entry")]
		public int CandleLookBackEntry
		{ get; set; }
		
		[NinjaScriptProperty]
		[Display(Name="Price Offset Entry", Order=1, GroupName="02. Entry")]
		public double PriceOffsetEntry
		{ get; set; }

		[NinjaScriptProperty]
		[Display(Name="Percentage Offset Entry", Order=2, GroupName="02. Entry")]
		public double PercentageOffsetEntry
		{ get; set; }

		[NinjaScriptProperty]
		[Display(Name="Tick Offset Entry", Order=3, GroupName="02. Entry")]
		public int TickOffsetEntry
		{ get; set; }

		#endregion
		
		#region 03. Stop
		
		[NinjaScriptProperty]
		[Range(1, int.MaxValue)]
		[Display(Name="Stop Candle Used", Order=0, GroupName="03. Stop")]
		public int CandleLookBackStop
		{ get; set; }
		
		[NinjaScriptProperty]
		[Display(Name="Price Offset Stop", Order=1, GroupName="03. Stop")]
		public double PriceOffsetStop
		{ get; set; }

		[NinjaScriptProperty]
		[Display(Name="Percentage Offset Stop", Order=2, GroupName="03. Stop")]
		public double PercentageOffsetStop
		{ get; set; }

		[NinjaScriptProperty]
		[Display(Name="Tick Offset Stop", Order=3, GroupName="03. Stop")]
		public int TickOffsetStop
		{ get; set; }

		#endregion
		
		#region 04. Display Text Box
		
		[NinjaScriptProperty]
		[Display(Name="Display Text", Order=1, GroupName="04. Display Text Box")]
		public bool DisplayText
		{ get; set; }
		
		#endregion
		
		#region 29. TradeSaber Socials
		
		[NinjaScriptProperty]
		[Display(Name = "Show Social Media Buttons", Description = "", Order = 0, GroupName = "29. TradeSaber Socials")]
		public bool ShowSocials 
		{
		 	get{return showSocials;} 
			set{showSocials = (value);} 
		}
		
		[NinjaScriptProperty]
		[Display(Name="Explanation Video", Order=1, GroupName="29. TradeSaber Socials")]
		public  string Youtube
		{
		 	get{return youtube;} 
			set{youtube = (value);} 
		}
		
		[NinjaScriptProperty]
		[Display(Name="Discord Link", Order=2, GroupName="29. TradeSaber Socials")]
		public  string Discord
		{
		 	get{return discord;} 
			set{discord = (value);} 
		}
		
		[NinjaScriptProperty]
		[Display(Name="TradeSaber Link", Order=3, GroupName="29. TradeSaber Socials")]
		public  string TradeSaber
		{
		 	get{return tradeSaber;} 
			set{tradeSaber = (value);} 
		}
		
		[NinjaScriptProperty]
		[ReadOnly(true)]
		[Display(Name = "Author", GroupName = "29. TradeSaber Socials", Order = 4)]
		public string Author
		{
		 	get{return author;} 
			set{author = (value);} 
		}
		
		[NinjaScriptProperty]
		[ReadOnly(true)]
		[Display(Name = "Version", GroupName = "29. TradeSaber Socials", Order = 5)]
		public string Version
		{
		 	get{return version;} 
			set{version = (value);} 
		}
		
		#endregion

		#region 99. Prints
		
		[NinjaScriptProperty]
		[Display(Name="SystemPrint", Order=1, GroupName="99. Prints")]
		public bool SystemPrint
		{ get; set; }
		
		[NinjaScriptProperty]
		[Display(Name="EntryPrints", Order=3, GroupName="99. Prints")]
		public bool EntryPrints
		{ get; set; }
		
		[NinjaScriptProperty]
		[Display(Name="StopPrints", Order=4, GroupName="99. Prints")]
		public bool StopPrints
		{ get; set; }
		
		#endregion
		
		#endregion
	}
}

#region NinjaScript generated code. Neither change nor remove.

namespace NinjaTrader.NinjaScript.Indicators
{
	public partial class Indicator : NinjaTrader.Gui.NinjaScript.IndicatorRenderBase
	{
		private TradeSaber.AutoShareCalc[] cacheAutoShareCalc;
		public TradeSaber.AutoShareCalc AutoShareCalc(double maxLossPerTrade, bool candleRange, bool addOffset, int candleLookBackEntry, double priceOffsetEntry, double percentageOffsetEntry, int tickOffsetEntry, int candleLookBackStop, double priceOffsetStop, double percentageOffsetStop, int tickOffsetStop, bool displayText, bool showSocials, string youtube, string discord, string tradeSaber, string author, string version, bool systemPrint, bool entryPrints, bool stopPrints)
		{
			return AutoShareCalc(Input, maxLossPerTrade, candleRange, addOffset, candleLookBackEntry, priceOffsetEntry, percentageOffsetEntry, tickOffsetEntry, candleLookBackStop, priceOffsetStop, percentageOffsetStop, tickOffsetStop, displayText, showSocials, youtube, discord, tradeSaber, author, version, systemPrint, entryPrints, stopPrints);
		}

		public TradeSaber.AutoShareCalc AutoShareCalc(ISeries<double> input, double maxLossPerTrade, bool candleRange, bool addOffset, int candleLookBackEntry, double priceOffsetEntry, double percentageOffsetEntry, int tickOffsetEntry, int candleLookBackStop, double priceOffsetStop, double percentageOffsetStop, int tickOffsetStop, bool displayText, bool showSocials, string youtube, string discord, string tradeSaber, string author, string version, bool systemPrint, bool entryPrints, bool stopPrints)
		{
			if (cacheAutoShareCalc != null)
				for (int idx = 0; idx < cacheAutoShareCalc.Length; idx++)
					if (cacheAutoShareCalc[idx] != null && cacheAutoShareCalc[idx].MaxLossPerTrade == maxLossPerTrade && cacheAutoShareCalc[idx].CandleRange == candleRange && cacheAutoShareCalc[idx].AddOffset == addOffset && cacheAutoShareCalc[idx].CandleLookBackEntry == candleLookBackEntry && cacheAutoShareCalc[idx].PriceOffsetEntry == priceOffsetEntry && cacheAutoShareCalc[idx].PercentageOffsetEntry == percentageOffsetEntry && cacheAutoShareCalc[idx].TickOffsetEntry == tickOffsetEntry && cacheAutoShareCalc[idx].CandleLookBackStop == candleLookBackStop && cacheAutoShareCalc[idx].PriceOffsetStop == priceOffsetStop && cacheAutoShareCalc[idx].PercentageOffsetStop == percentageOffsetStop && cacheAutoShareCalc[idx].TickOffsetStop == tickOffsetStop && cacheAutoShareCalc[idx].DisplayText == displayText && cacheAutoShareCalc[idx].ShowSocials == showSocials && cacheAutoShareCalc[idx].Youtube == youtube && cacheAutoShareCalc[idx].Discord == discord && cacheAutoShareCalc[idx].TradeSaber == tradeSaber && cacheAutoShareCalc[idx].Author == author && cacheAutoShareCalc[idx].Version == version && cacheAutoShareCalc[idx].SystemPrint == systemPrint && cacheAutoShareCalc[idx].EntryPrints == entryPrints && cacheAutoShareCalc[idx].StopPrints == stopPrints && cacheAutoShareCalc[idx].EqualsInput(input))
						return cacheAutoShareCalc[idx];
			return CacheIndicator<TradeSaber.AutoShareCalc>(new TradeSaber.AutoShareCalc(){ MaxLossPerTrade = maxLossPerTrade, CandleRange = candleRange, AddOffset = addOffset, CandleLookBackEntry = candleLookBackEntry, PriceOffsetEntry = priceOffsetEntry, PercentageOffsetEntry = percentageOffsetEntry, TickOffsetEntry = tickOffsetEntry, CandleLookBackStop = candleLookBackStop, PriceOffsetStop = priceOffsetStop, PercentageOffsetStop = percentageOffsetStop, TickOffsetStop = tickOffsetStop, DisplayText = displayText, ShowSocials = showSocials, Youtube = youtube, Discord = discord, TradeSaber = tradeSaber, Author = author, Version = version, SystemPrint = systemPrint, EntryPrints = entryPrints, StopPrints = stopPrints }, input, ref cacheAutoShareCalc);
		}
	}
}

namespace NinjaTrader.NinjaScript.MarketAnalyzerColumns
{
	public partial class MarketAnalyzerColumn : MarketAnalyzerColumnBase
	{
		public Indicators.TradeSaber.AutoShareCalc AutoShareCalc(double maxLossPerTrade, bool candleRange, bool addOffset, int candleLookBackEntry, double priceOffsetEntry, double percentageOffsetEntry, int tickOffsetEntry, int candleLookBackStop, double priceOffsetStop, double percentageOffsetStop, int tickOffsetStop, bool displayText, bool showSocials, string youtube, string discord, string tradeSaber, string author, string version, bool systemPrint, bool entryPrints, bool stopPrints)
		{
			return indicator.AutoShareCalc(Input, maxLossPerTrade, candleRange, addOffset, candleLookBackEntry, priceOffsetEntry, percentageOffsetEntry, tickOffsetEntry, candleLookBackStop, priceOffsetStop, percentageOffsetStop, tickOffsetStop, displayText, showSocials, youtube, discord, tradeSaber, author, version, systemPrint, entryPrints, stopPrints);
		}

		public Indicators.TradeSaber.AutoShareCalc AutoShareCalc(ISeries<double> input , double maxLossPerTrade, bool candleRange, bool addOffset, int candleLookBackEntry, double priceOffsetEntry, double percentageOffsetEntry, int tickOffsetEntry, int candleLookBackStop, double priceOffsetStop, double percentageOffsetStop, int tickOffsetStop, bool displayText, bool showSocials, string youtube, string discord, string tradeSaber, string author, string version, bool systemPrint, bool entryPrints, bool stopPrints)
		{
			return indicator.AutoShareCalc(input, maxLossPerTrade, candleRange, addOffset, candleLookBackEntry, priceOffsetEntry, percentageOffsetEntry, tickOffsetEntry, candleLookBackStop, priceOffsetStop, percentageOffsetStop, tickOffsetStop, displayText, showSocials, youtube, discord, tradeSaber, author, version, systemPrint, entryPrints, stopPrints);
		}
	}
}

namespace NinjaTrader.NinjaScript.Strategies
{
	public partial class Strategy : NinjaTrader.Gui.NinjaScript.StrategyRenderBase
	{
		public Indicators.TradeSaber.AutoShareCalc AutoShareCalc(double maxLossPerTrade, bool candleRange, bool addOffset, int candleLookBackEntry, double priceOffsetEntry, double percentageOffsetEntry, int tickOffsetEntry, int candleLookBackStop, double priceOffsetStop, double percentageOffsetStop, int tickOffsetStop, bool displayText, bool showSocials, string youtube, string discord, string tradeSaber, string author, string version, bool systemPrint, bool entryPrints, bool stopPrints)
		{
			return indicator.AutoShareCalc(Input, maxLossPerTrade, candleRange, addOffset, candleLookBackEntry, priceOffsetEntry, percentageOffsetEntry, tickOffsetEntry, candleLookBackStop, priceOffsetStop, percentageOffsetStop, tickOffsetStop, displayText, showSocials, youtube, discord, tradeSaber, author, version, systemPrint, entryPrints, stopPrints);
		}

		public Indicators.TradeSaber.AutoShareCalc AutoShareCalc(ISeries<double> input , double maxLossPerTrade, bool candleRange, bool addOffset, int candleLookBackEntry, double priceOffsetEntry, double percentageOffsetEntry, int tickOffsetEntry, int candleLookBackStop, double priceOffsetStop, double percentageOffsetStop, int tickOffsetStop, bool displayText, bool showSocials, string youtube, string discord, string tradeSaber, string author, string version, bool systemPrint, bool entryPrints, bool stopPrints)
		{
			return indicator.AutoShareCalc(input, maxLossPerTrade, candleRange, addOffset, candleLookBackEntry, priceOffsetEntry, percentageOffsetEntry, tickOffsetEntry, candleLookBackStop, priceOffsetStop, percentageOffsetStop, tickOffsetStop, displayText, showSocials, youtube, discord, tradeSaber, author, version, systemPrint, entryPrints, stopPrints);
		}
	}
}

#endregion
