#region Using declarations
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.ComponentModel.DataAnnotations;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Input;
using System.Windows.Media;
using System.Xml.Serialization;
using NinjaTrader.Cbi;
using NinjaTrader.Gui;
using NinjaTrader.Gui.Chart;
using NinjaTrader.Gui.SuperDom;
using NinjaTrader.Gui.Tools;
using NinjaTrader.Data;
using NinjaTrader.NinjaScript;
using NinjaTrader.Core.FloatingPoint;
using NinjaTrader.NinjaScript.DrawingTools;
#endregion

//This namespace holds Indicators in this folder and is required. Do not change it. 
namespace NinjaTrader.NinjaScript.Indicators.TradeSaber_SignalMod
{
	public class DoubleStochSignalMod : Indicator
	{
		private EMA				emaP1;
		private EMA				emaP3;
		private	MIN				minLow;
		private MIN				minP2;
		private	MAX				maxHigh;
		private MAX				maxP2;
		private Series<double>	p1;
		private Series<double>	p2;
		private Series<double>	p3;
		
		private double upperMax = 90; //OverSold
		private double lowerMin = 10; //OverBought
		
		private int overSoldOpacity 	= 25;
		private int overBoughtOpacity 	= 25;
		
		private bool highlightChart;
		private bool highlighIndicator;
		
		private string author = "TradeSaber(Dre)";
		private string version = "Version 1.2 // December 2022";
		
		protected override void OnStateChange()
		{
			if (State == State.SetDefaults)
			{
				Description									= @"Enter the description for your new custom Indicator here.";
				Name										= "DoubleStochSignalMod";
				Calculate					= Calculate.OnBarClose;
				IsSuspendedWhileInactive	= true;
				Period						= 10;

				AddPlot(Brushes.Crimson,													NinjaTrader.Custom.Resource.StochasticsK);
				
				OverBoughtArea								= Brushes.Red;
				OverSoldArea								= Brushes.Green;
				
				highlightChart								= true;
				highlighIndicator							= false;
				
				
				CrossAboveUpperBool							= true;
				CrossBelowUpperBool							= true;
				CrossAboveLowerBool							= true;
				CrossBelowLowerBool							= true;
				
				CrossAboveUpperString						= "CrossAboveUpper";
				CrossBelowUpperString						= "CrossBelowUpper";
				CrossAboveLowerString						= "CrossAboveLower"; 
				CrossBelowLowerString						= "CrossBelowLower";
				
				AddLine(new Gui.Stroke(Brushes.DodgerBlue, Gui.DashStyleHelper.Dash, 1), 90,	NinjaTrader.Custom.Resource.NinjaScriptIndicatorUpper);
				AddLine(new Gui.Stroke(Brushes.DodgerBlue, Gui.DashStyleHelper.Dash, 1), 10,	NinjaTrader.Custom.Resource.NinjaScriptIndicatorLower);
			}
			
			else if (State == State.Configure)
			{
			///https://ninjatrader.com/support/forum/forum/ninjatrader-8/indicator-development/1090657-issue-with-backbrush
				
				Brush tempB = OverBoughtArea.Clone(); //Copy the brush into a temporary brush
				tempB.Opacity = overBoughtOpacity / 100.0; // set the opacity
				tempB.Freeze(); // freeze the temp brush
				OverBoughtArea = tempB; // assign the temp brush value to OverBoughtArea.
				
				
				Brush tempS = OverSoldArea.Clone(); //Copy the brush into a temporary brush
				tempS.Opacity = overSoldOpacity / 100.0; // set the opacity
				tempS.Freeze(); // freeze the temp brush
				OverSoldArea = tempS; // assign the temp brush value to OverSoldArea.
			}
			
			else if (State == State.DataLoaded)
			{
				p1		= new Series<double>(this);
				p2		= new Series<double>(this);
				p3		= new Series<double>(this);
				emaP1	= EMA(p1, 3);
				emaP3	= EMA(p3, 3);
				maxHigh	= MAX(High, Period);
				maxP2	= MAX(p2, Period);
				minLow	= MIN(Low, Period);
				minP2	= MIN(p2, Period);
			}
		}

		protected override void OnBarUpdate()
		{
			
			BackBrushAll = null;
			BackBrush = null;
					
			double maxHigh0		= maxHigh[0];
			double minLow0		= minLow[0];
			double r			= maxHigh0 - minLow0;
			r					= r.ApproxCompare(0) == 0 ? 0 : r;

			if (r == 0)
				p1[0] = CurrentBar == 0 ? 50 : p1[1];
			else
				p1[0] = Math.Min(100, Math.Max(0, 100 * (Close[0] - minLow0) / r));

			p2[0]				= emaP1[0];
			double minP20		= minP2[0];
			double s			= maxP2[0] - minP20;
			s					= s.ApproxCompare(0) == 0 ? 0 : s;

			if (s == 0)
				p3[0] = CurrentBar == 0 ? 50 : p3[1];
			else
				p3[0] = Math.Min(100, Math.Max(0, 100 * (p2[0] - minP20) / s));

			K[0] = emaP3[0];
			
		Print(K[0] + " " + Time[0]);
			
			
			if (CrossAbove(K, upperMax, 1) && CrossAboveUpperBool)
				Draw.ArrowUp(this, CrossAboveUpperString + CurrentBar, true, 0, Low[0] - TickSize, Brushes.Green);
			
			if (CrossBelow(K, upperMax, 1) && CrossBelowUpperBool)
				Draw.ArrowDown(this, CrossBelowUpperString + CurrentBar, true, 0, High[0] - TickSize, Brushes.Red);
				
			
			if (CrossAbove(K, lowerMin, 1) && CrossAboveLowerBool)
				Draw.ArrowUp(this, CrossAboveLowerString + CurrentBar, true, 0, Low[0] - TickSize, Brushes.HotPink);
			
			if (CrossBelow(K, lowerMin, 1) && CrossBelowLowerBool)
				Draw.ArrowDown(this, CrossBelowLowerString + CurrentBar, true, 0, High[0] - TickSize, Brushes.DodgerBlue);
			
		#region Color regions
			
		/// Color Overbought and Oversold Regions	
			
			if (highlightChart)
			{
				if (K[0] >= upperMax)
					
				{
					BackBrushesAll[0] = OverBoughtArea;
				}
					
				if (K[0] <= lowerMin)
					
				{
					BackBrushesAll[0] = OverSoldArea;
				}
			}
				
			if (highlighIndicator)
			{
					if (K[0] >= upperMax)
					
				{
					BackBrushes[0] = OverBoughtArea;
				}
					
				if (K[0] <= lowerMin)
					
				{
					BackBrushes[0] = OverSoldArea;
				}
			}
				
				else 
				{
					return;
				}
		
		#endregion
				
		}
		
		#region Properties
		
		#region 01. Overbought Properties
		
		[Display(Name = "Overbought Period", GroupName = "01. Overbought(Upper)", Order = 0)]
		public double UpperMax
		{
			get{return upperMax;}
			set{upperMax = (value);}
		}
		
		[XmlIgnore()]
		[Display(Name = "Overbought Zone", GroupName = "01. Overbought(Upper)", Order = 1)]
		public Brush OverBoughtArea
		{ get; set; }
		
		// Serialize our Color object
		[Browsable(false)]
		public string OverBoughtAreaSerialize
		{
			get { return Serialize.BrushToString(OverBoughtArea); }
   			set { OverBoughtArea = Serialize.StringToBrush(value); }
		}
		
		[Range(0, 100)]
		[Display(Name = "Opacity %", GroupName = "01. Overbought(Upper)", Order = 2)]
		public int OverBoughtOpacity
		{
			get{return overBoughtOpacity;}
			set{overBoughtOpacity = (value);}
		}
		
		#endregion
		
		#region 02. Oversold Properties
		
		[Display(Name = "Oversold Period", GroupName = "02. Oversold(Lower)", Order = 0)]
		public double LowerMin
		{
			get{return lowerMin;}
			set{lowerMin = (value);}
		}
		
		
		[XmlIgnore()]
		[Display(Name = "Oversold Zone", GroupName = "02. Oversold(Lower)", Order = 1)]
		public Brush OverSoldArea
		{ get; set; }
		
		// Serialize our Color object
		[Browsable(false)]
		public string OverSoldAreaSerialize
		{
			get { return Serialize.BrushToString(OverSoldArea); }
   			set { OverSoldArea = Serialize.StringToBrush(value); }
		}
		
		[Range(0, 100)]
		[Display(Name = "Opacity %", GroupName = "02. Oversold(Lower)", Order = 2)]
		public int OverSoldOpacity
		{
			get{return overSoldOpacity;}
			set{overSoldOpacity = (value);}
		}
		
		#endregion
		
		#region 03. Highlight Options
		
		[RefreshProperties(RefreshProperties.All)]
		[NinjaScriptProperty]
		[Display(Name = "Chart and Indicator", Order = 1, GroupName = "03. Highlight Options")]
		public bool HighlightChart
		{
		    get
		   {
		      return highlightChart;
		   }
		   set
		   {
		      if (value == true)
		      {
		         HighlighIndicator = false;
		      }
		      highlightChart = value;
		    }
		}

		[RefreshProperties(RefreshProperties.All)]
		[NinjaScriptProperty]
		[Display(Name = "Indicator Only", Order = 2, GroupName = "03. Highlight Options")]
		public bool HighlighIndicator
		{
		   get
		   {
		      return highlighIndicator;
		   }
		   set
		   {
		      if (value == true)
		      {
		         HighlightChart = false;
		      }
		      highlighIndicator = value;
		   }
		}
		
		
		
		[NinjaScriptProperty]
		[Display(Name = "CrossAboveUpperBool", Description = "", Order = 1, GroupName = "04. Signals")]
		public bool CrossAboveUpperBool
		{ get; set; }
		
		[NinjaScriptProperty]
		[Display(Name = "CrossBelowUpperBool", Description = "", Order = 2, GroupName = "04. Signals")]
		public bool CrossBelowUpperBool
		{ get; set; }
		
		[NinjaScriptProperty]
		[Display(Name = "CrossAboveLowerBool", Description = "", Order = 3, GroupName = "04. Signals")]
		public bool CrossAboveLowerBool
		{ get; set; }
		
		[NinjaScriptProperty]
		[Display(Name = "CrossBelowLowerBool", Description = "", Order = 4, GroupName = "04. Signals")]
		public bool CrossBelowLowerBool
		{ get; set; }
		
		
		[NinjaScriptProperty]
		[Display(Name = "CrossAboveUpperString", Description = "", Order = 5, GroupName = "04. Signals")]
		public String CrossAboveUpperString
		{ get; set; }
		
		[NinjaScriptProperty]
		[Display(Name = "CrossBelowUpperString", Description = "", Order = 6, GroupName = "04. Signals")]
		public String CrossBelowUpperString
		{ get; set; }
		
		[NinjaScriptProperty]
		[Display(Name = "CrossAboveLowerString", Description = "", Order = 7, GroupName = "04. Signals")]
		public String CrossAboveLowerString
		{ get; set; }
		
		[NinjaScriptProperty]
		[Display(Name = "CrossBelowLowerString", Description = "", Order = 8, GroupName = "04. Signals")]
		public String CrossBelowLowerString
		{ get; set; }
		
		#endregion
		
		#region 29. TradeSaber Socials
		
		[NinjaScriptProperty]
		[ReadOnly(true)]
		[Display(Name = "Author", GroupName = "29. TradeSaber Socials", Order = 4)]
		public string Author
		{
		 	get{return author;} 
			set{author = (value);} 
		}
		
		[NinjaScriptProperty]
		[ReadOnly(true)]
		[Display(Name = "Version", GroupName = "29. TradeSaber Socials", Order = 5)]
		public string Version
		{
		 	get{return version;} 
			set{version = (value);} 
		}
		
		#endregion
		
		[Browsable(false)]	// this line prevents the data series from being displayed in the indicator properties dialog, do not remove
		[XmlIgnore()]		// this line ensures that the indicator can be saved/recovered as part of a chart template, do not remove
		public Series<double> K
		{
			get { return Values[0]; }
		}

		[Range(1, int.MaxValue), NinjaScriptProperty]
		[Display(ResourceType = typeof(Custom.Resource), Name = "Period", GroupName = "NinjaScriptParameters", Order = 0)]
		public int Period
		{ get; set; }
		
		
		#endregion
	}
}

#region NinjaScript generated code. Neither change nor remove.

namespace NinjaTrader.NinjaScript.Indicators
{
	public partial class Indicator : NinjaTrader.Gui.NinjaScript.IndicatorRenderBase
	{
		private TradeSaber_SignalMod.DoubleStochSignalMod[] cacheDoubleStochSignalMod;
		public TradeSaber_SignalMod.DoubleStochSignalMod DoubleStochSignalMod(bool highlightChart, bool highlighIndicator, bool crossAboveUpperBool, bool crossBelowUpperBool, bool crossAboveLowerBool, bool crossBelowLowerBool, String crossAboveUpperString, String crossBelowUpperString, String crossAboveLowerString, String crossBelowLowerString, string author, string version, int period)
		{
			return DoubleStochSignalMod(Input, highlightChart, highlighIndicator, crossAboveUpperBool, crossBelowUpperBool, crossAboveLowerBool, crossBelowLowerBool, crossAboveUpperString, crossBelowUpperString, crossAboveLowerString, crossBelowLowerString, author, version, period);
		}

		public TradeSaber_SignalMod.DoubleStochSignalMod DoubleStochSignalMod(ISeries<double> input, bool highlightChart, bool highlighIndicator, bool crossAboveUpperBool, bool crossBelowUpperBool, bool crossAboveLowerBool, bool crossBelowLowerBool, String crossAboveUpperString, String crossBelowUpperString, String crossAboveLowerString, String crossBelowLowerString, string author, string version, int period)
		{
			if (cacheDoubleStochSignalMod != null)
				for (int idx = 0; idx < cacheDoubleStochSignalMod.Length; idx++)
					if (cacheDoubleStochSignalMod[idx] != null && cacheDoubleStochSignalMod[idx].HighlightChart == highlightChart && cacheDoubleStochSignalMod[idx].HighlighIndicator == highlighIndicator && cacheDoubleStochSignalMod[idx].CrossAboveUpperBool == crossAboveUpperBool && cacheDoubleStochSignalMod[idx].CrossBelowUpperBool == crossBelowUpperBool && cacheDoubleStochSignalMod[idx].CrossAboveLowerBool == crossAboveLowerBool && cacheDoubleStochSignalMod[idx].CrossBelowLowerBool == crossBelowLowerBool && cacheDoubleStochSignalMod[idx].CrossAboveUpperString == crossAboveUpperString && cacheDoubleStochSignalMod[idx].CrossBelowUpperString == crossBelowUpperString && cacheDoubleStochSignalMod[idx].CrossAboveLowerString == crossAboveLowerString && cacheDoubleStochSignalMod[idx].CrossBelowLowerString == crossBelowLowerString && cacheDoubleStochSignalMod[idx].Author == author && cacheDoubleStochSignalMod[idx].Version == version && cacheDoubleStochSignalMod[idx].Period == period && cacheDoubleStochSignalMod[idx].EqualsInput(input))
						return cacheDoubleStochSignalMod[idx];
			return CacheIndicator<TradeSaber_SignalMod.DoubleStochSignalMod>(new TradeSaber_SignalMod.DoubleStochSignalMod(){ HighlightChart = highlightChart, HighlighIndicator = highlighIndicator, CrossAboveUpperBool = crossAboveUpperBool, CrossBelowUpperBool = crossBelowUpperBool, CrossAboveLowerBool = crossAboveLowerBool, CrossBelowLowerBool = crossBelowLowerBool, CrossAboveUpperString = crossAboveUpperString, CrossBelowUpperString = crossBelowUpperString, CrossAboveLowerString = crossAboveLowerString, CrossBelowLowerString = crossBelowLowerString, Author = author, Version = version, Period = period }, input, ref cacheDoubleStochSignalMod);
		}
	}
}

namespace NinjaTrader.NinjaScript.MarketAnalyzerColumns
{
	public partial class MarketAnalyzerColumn : MarketAnalyzerColumnBase
	{
		public Indicators.TradeSaber_SignalMod.DoubleStochSignalMod DoubleStochSignalMod(bool highlightChart, bool highlighIndicator, bool crossAboveUpperBool, bool crossBelowUpperBool, bool crossAboveLowerBool, bool crossBelowLowerBool, String crossAboveUpperString, String crossBelowUpperString, String crossAboveLowerString, String crossBelowLowerString, string author, string version, int period)
		{
			return indicator.DoubleStochSignalMod(Input, highlightChart, highlighIndicator, crossAboveUpperBool, crossBelowUpperBool, crossAboveLowerBool, crossBelowLowerBool, crossAboveUpperString, crossBelowUpperString, crossAboveLowerString, crossBelowLowerString, author, version, period);
		}

		public Indicators.TradeSaber_SignalMod.DoubleStochSignalMod DoubleStochSignalMod(ISeries<double> input , bool highlightChart, bool highlighIndicator, bool crossAboveUpperBool, bool crossBelowUpperBool, bool crossAboveLowerBool, bool crossBelowLowerBool, String crossAboveUpperString, String crossBelowUpperString, String crossAboveLowerString, String crossBelowLowerString, string author, string version, int period)
		{
			return indicator.DoubleStochSignalMod(input, highlightChart, highlighIndicator, crossAboveUpperBool, crossBelowUpperBool, crossAboveLowerBool, crossBelowLowerBool, crossAboveUpperString, crossBelowUpperString, crossAboveLowerString, crossBelowLowerString, author, version, period);
		}
	}
}

namespace NinjaTrader.NinjaScript.Strategies
{
	public partial class Strategy : NinjaTrader.Gui.NinjaScript.StrategyRenderBase
	{
		public Indicators.TradeSaber_SignalMod.DoubleStochSignalMod DoubleStochSignalMod(bool highlightChart, bool highlighIndicator, bool crossAboveUpperBool, bool crossBelowUpperBool, bool crossAboveLowerBool, bool crossBelowLowerBool, String crossAboveUpperString, String crossBelowUpperString, String crossAboveLowerString, String crossBelowLowerString, string author, string version, int period)
		{
			return indicator.DoubleStochSignalMod(Input, highlightChart, highlighIndicator, crossAboveUpperBool, crossBelowUpperBool, crossAboveLowerBool, crossBelowLowerBool, crossAboveUpperString, crossBelowUpperString, crossAboveLowerString, crossBelowLowerString, author, version, period);
		}

		public Indicators.TradeSaber_SignalMod.DoubleStochSignalMod DoubleStochSignalMod(ISeries<double> input , bool highlightChart, bool highlighIndicator, bool crossAboveUpperBool, bool crossBelowUpperBool, bool crossAboveLowerBool, bool crossBelowLowerBool, String crossAboveUpperString, String crossBelowUpperString, String crossAboveLowerString, String crossBelowLowerString, string author, string version, int period)
		{
			return indicator.DoubleStochSignalMod(input, highlightChart, highlighIndicator, crossAboveUpperBool, crossBelowUpperBool, crossAboveLowerBool, crossBelowLowerBool, crossAboveUpperString, crossBelowUpperString, crossAboveLowerString, crossBelowLowerString, author, version, period);
		}
	}
}

#endregion
