#region Using declarations
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.ComponentModel.DataAnnotations;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Input;
using System.Windows.Media;
using System.Xml.Serialization;
using NinjaTrader.Cbi;
using NinjaTrader.Gui;
using NinjaTrader.Gui.Chart;
using NinjaTrader.Gui.SuperDom;
using NinjaTrader.Gui.Tools;
using NinjaTrader.Data;
using NinjaTrader.NinjaScript;
using NinjaTrader.Core.FloatingPoint;
using NinjaTrader.NinjaScript.DrawingTools;
#endregion

//This namespace holds Indicators in this folder and is required. Do not change it. 
namespace NinjaTrader.NinjaScript.Indicators.TradeSaber
{
	public class TTMSqueezeTradeSaber : Indicator
	{
		/// <summary>
		/// This is a simple version of the indicator created by John F. Carter. Credit goes to him for the indicator. See this site for details:
		/// https://www.simplertrading.com/blog/how-to-use-the-ttm-squeeze
		/// 
		/// Coded by TradeSaber(Dre). Download more free content from: 
		/// https://tradesaber.com/
		/// 
		/// ==========================================
		/// 
		/// Squeeze happens when the Bollinger bands - Upper and Lower are both inside the Keltner Channel. This is considered a period of consolidation.
		/// Breakout happens when the Bollinger bands cross outside of the keltner channel (Orange Dot)
		/// 
		/// We enter Long when the Dot turns orange and the momentum is greater than 0.
		/// We enter Short when the Dot turns orange and the momentum is less than 0.
		/// 
		/// 
		/// Partials should be taken for profit. It is recommended to exit when the momentum oscillator starts retracting. 
		/// Exit Long when the momentum starts going down.
		/// Exit Short when the momentum starts going up.
		/// 
		/// ==========================================
		/// 
		/// Use the Signal Tags in the 'Predator Signal' section of the properties to easily Automate this indicator using the Predator X Order Entry. 
		/// 
		/// Strategy Builder friendly as well.
		/// +1 	= Entry Long
		/// -1 	= Entry Short
		/// +2 	= Exit Long
		/// -2	= Exit Short
		/// 
		/// Watch this video for instructions on how to automate this indicator: 
		/// https://youtu.be/YjPgIcTjiKI
		/// 
		/// </summary>
		
		private bool SignalOnceEntry = false;
		private bool SignalOnceExit	= false;
		
		private double BollU;
		private double BollL;
		private double KeltU;
		private double KeltL;
		
		///Added these after the video
		private bool isLong 	= false;
		private bool isShort 	= false;
		
		#region TradeSaber Social
		
		private bool YouTubeButtonClicked;
		private bool DiscordButtonClicked;
		private bool tradeSaberButtonClicked;
		
		private System.Windows.Controls.Button YouTubeButton;
		private System.Windows.Controls.Button DiscordButton;
		private System.Windows.Controls.Button tradeSaberButton;
		
		
		private System.Windows.Controls.Grid myGrid29;
		
		#endregion
		
		protected override void OnStateChange()
		{
			if (State == State.SetDefaults)
			{
				Description									= @"Enter the description for your new custom Indicator here.";
				Name										= "TTMSqueezeTradeSaber";
				Calculate									= Calculate.OnBarClose;
				IsOverlay									= false;
				DisplayInDataBox							= true;
				DrawOnPricePanel							= true;
				DrawHorizontalGridLines						= true;
				DrawVerticalGridLines						= true;
				PaintPriceMarkers							= true;
				ScaleJustification							= NinjaTrader.Gui.Chart.ScaleJustification.Right;
				//Disable this property if your indicator requires custom values that cumulate with each new market data event. 
				//See Help Guide for additional information.
				IsSuspendedWhileInactive					= true;
				ShowTransparentPlotsInDataBox				= true;
				
				BollingerDeviation							= 2;
				BollingerPeriod								= 21;
				
				KeltnerMultiplier							= 2;
				KeltnerPeriod								= 21;
				
				MomentumPeriod								= 14;
				MomentumEMAPeriod							= 14;
				
				ShowEntrySignals							= false;
				LongEntry									= "LongEntry";
				ShortEntry									= "ShortEntry";
				
				ShowExitSignals								= false;
				LongExit									= "LongExit";
				ShortExit									= "ShortExit";
				
				BreakoutColor								= Brushes.DarkOrange;
				
				MomLongStrongColor							= Brushes.DarkGreen;
				MomLongWeakColor							= Brushes.LightGreen;
				
				MomShortStrongColor							= Brushes.DarkRed;
				MomShortWeakColor							= Brushes.Red;
				
				AddPlot(new Stroke(Brushes.Gray, 2), PlotStyle.Bar, "MomentumTS"); //0
				AddPlot(new Stroke(Brushes.Gray, 2), PlotStyle.Dot, "Squeeze"); // 1
				
				AddPlot(new Stroke(Brushes.Transparent, 2), PlotStyle.Dot, "BuilderSignal"); //2
				
				#region TradeSaber Socials
				
				ShowSocials									= true;
				
				Author										= "Coded by TradeSaber(Dre)\nIndicator by John F. Carter";
				Version										= "Version 1.0 // September 2024";
				
				YouTube										= "https://youtu.be/YjPgIcTjiKI";
				Discord										= "https://Discord.gg/2YU9GDme8j";
				TradeSaber									= "https://TradeSaber.com/";
				
				#endregion
			}
			else if (State == State.Configure)
			{
			}
			
			#region Add Buttons with Links
			
			else if (State == State.Historical)
			{
				#region TradeSaber Socials
			
			if (ShowSocials)
			{
				if (UserControlCollection.Contains(myGrid29))
					return;
				
				Dispatcher.InvokeAsync((() =>
				{
					myGrid29 = new System.Windows.Controls.Grid
					{
						Name = "MyCustomGrid", 
						HorizontalAlignment = HorizontalAlignment.Left, 
						VerticalAlignment = VerticalAlignment.Bottom,
					};
					
					System.Windows.Controls.ColumnDefinition column1 = new System.Windows.Controls.ColumnDefinition();
					System.Windows.Controls.ColumnDefinition column2 = new System.Windows.Controls.ColumnDefinition();
					System.Windows.Controls.ColumnDefinition column3 = new System.Windows.Controls.ColumnDefinition();
					
					myGrid29.ColumnDefinitions.Add(column1);
					myGrid29.ColumnDefinitions.Add(column2);
					myGrid29.ColumnDefinitions.Add(column3);
					
					YouTubeButton = new System.Windows.Controls.Button
					{
						Name = "YoutubeButton", 
						Content = "Youtube", 
						Foreground = Brushes.White, 
						Background = Brushes.Red,
						Margin		= new Thickness(0,0,0,0),
						Padding		= new Thickness(0,0,0,0),
						FontSize	= 12,
						Height 		= 18,
						Width		= 45
					};
					
					DiscordButton = new System.Windows.Controls.Button
					{
						Name = "DiscordButton", 
						Content = "Discord", 
						Foreground = Brushes.White, 
						Background = Brushes.RoyalBlue,
						Margin		= new Thickness(0,0,0,0),
						Padding		= new Thickness(0,0,0,0),
						FontSize	= 12,
						Height 		= 18,
						Width 		= 45
					};
					
					tradeSaberButton = new System.Windows.Controls.Button
					{
						Name = "TradeSaberButton", 
						Content = "TradeSaber", 
						Foreground = Brushes.White, 
						Background = Brushes.DarkOrange,
						Margin		= new Thickness(0,0,0,0),
						Padding		= new Thickness(0,0,0,0),
						FontSize	= 12,
						Height 		= 18,
						Width 		= 45
					};
					
					YouTubeButton.Click += OnButtonClick;
					DiscordButton.Click += OnButtonClick;
					tradeSaberButton.Click += OnButtonClick;
					
					System.Windows.Controls.Grid.SetColumn(YouTubeButton, 0);
					System.Windows.Controls.Grid.SetColumn(DiscordButton, 1);
					System.Windows.Controls.Grid.SetColumn(tradeSaberButton, 2);
					
					myGrid29.Children.Add(YouTubeButton);
					myGrid29.Children.Add(DiscordButton);
					myGrid29.Children.Add(tradeSaberButton);
					
					UserControlCollection.Add(myGrid29);
				}));
			}
			#endregion
			}	
			else if (State == State.Terminated)
			{
				#region Terminate TradeSaber Socials
			
				if (ShowSocials)
				{
					Dispatcher.InvokeAsync((() =>
					{
						if (myGrid29 != null)
						{
							if (YouTubeButton != null)
							{
								myGrid29.Children.Remove(YouTubeButton);
								YouTubeButton.Click -= OnButtonClick;
								YouTubeButton = null;
							}
							
							if (DiscordButton != null)
							{
								myGrid29.Children.Remove(DiscordButton);
								DiscordButton.Click -= OnButtonClick;
								DiscordButton = null;
							}
							
							if (tradeSaberButton != null)
							{
								myGrid29.Children.Remove(tradeSaberButton);
								tradeSaberButton.Click -= OnButtonClick;
								tradeSaberButton = null;
							}		
						}
					}));
				}
				#endregion
			}
		
			#endregion
		}

		#region Button Click Event
		
		private void OnButtonClick(object sender, RoutedEventArgs rea)
		{
			System.Windows.Controls.Button button = sender as System.Windows.Controls.Button;
			
			#region TradeSaber Socials
			
			if (ShowSocials)
			{
				if (button == YouTubeButton && button.Name == "YoutubeButton" && button.Content == "Youtube")
				{
					System.Diagnostics.Process.Start(YouTube);
					return;
				}
				
				if (button == DiscordButton && button.Name == "DiscordButton" && button.Content == "Discord")
				{	
					System.Diagnostics.Process.Start(Discord);
					return;
				}
				
				if (button == tradeSaberButton && button.Name == "TradeSaberButton" && button.Content == "TradeSaber")
				{	
					System.Diagnostics.Process.Start(TradeSaber);
					return;
				}
			}
			
			#endregion
		}
	
	#endregion
		
		public override string DisplayName
		{
        	get 
			{ 
				if  (State == State.SetDefaults) 
				return Name; 
		
				else  return "TTM Squeeze - TradeSaber"; 
			}
		}
		
		protected override void OnBarUpdate()
		{
			if (CurrentBar < 2) return;
			
			BollU		= Bollinger(BollingerDeviation, BollingerPeriod).Upper[0];
			BollL		= Bollinger(BollingerDeviation, BollingerPeriod).Lower[0];
			
			KeltU		= KeltnerChannel(KeltnerMultiplier, KeltnerPeriod).Upper[0];
			KeltL		= KeltnerChannel(KeltnerMultiplier, KeltnerPeriod).Lower[0];
			
			Squeeze[0]	= 0;
			
			MomentumTS[0] = Momentum(EMA(MomentumEMAPeriod), MomentumPeriod)[0];
			
			
			if (BollU > KeltU && MomentumTS[0] > 0 && ((!SignalOnceEntry && MomentumTS[0] > MomentumTS[1]) || SignalOnceEntry))
			{
				PlotBrushes[1][0]	= BreakoutColor;
				
				if (!SignalOnceEntry)
				{
					BuilderSignal[0] = 1;
					SignalOnceEntry = true;
					SignalOnceExit	= false;
					isLong			= true;
					
					if (ShowEntrySignals)
						Draw.ArrowUp(this, LongEntry + CurrentBar, true, 0, Low[0] - TickSize, Brushes.Green);
				}
				
				else if (SignalOnceEntry && !SignalOnceExit && MomentumTS[0] < MomentumTS[1])
				{
					BuilderSignal[0] = 2;
					SignalOnceExit	= true;
					isLong			= false;
					
					if (ShowExitSignals)
						Draw.ArrowDown(this, LongExit + CurrentBar, true, 0, High[0] + TickSize, Brushes.Red);
				}
			}
			
			else if (BollL < KeltL && MomentumTS[0] < 0 && ((!SignalOnceEntry && MomentumTS[0] < MomentumTS[1]) || SignalOnceEntry))
			{
				PlotBrushes[1][0]	= BreakoutColor;
				
				if (!SignalOnceEntry)
				{
					BuilderSignal[0] = -1;
					SignalOnceEntry = true;
					SignalOnceExit	= false;
					isShort			= true;
					
					if (ShowEntrySignals)
						Draw.ArrowDown(this, ShortEntry + CurrentBar, true, 0, High[0] + TickSize, Brushes.DodgerBlue);
				}
				
				else if (SignalOnceEntry && !SignalOnceExit && MomentumTS[0] > MomentumTS[1])
				{
					BuilderSignal[0] = -2;
					SignalOnceExit	= true;
					isShort			= false;
					
					if (ShowExitSignals)
						Draw.ArrowUp(this, ShortExit + CurrentBar, true, 0, Low[0] - TickSize, Brushes.HotPink);
				}
			}
			
			else if (BollU < KeltU && BollL > KeltL && SignalOnceEntry) //Added parts after the video
			{
				SignalOnceEntry = false;
				
				if (isLong)
				{
					BuilderSignal[0] = 2;
					isLong			= false;
					
					if (ShowExitSignals)
					Draw.ArrowDown(this, LongExit + CurrentBar, true, 0, High[0] + TickSize, Brushes.Red);
				}
				else if (isShort)
				{
					BuilderSignal[0] = -2;
					isShort			= false;
					
					if (ShowExitSignals)
					Draw.ArrowUp(this, ShortExit + CurrentBar, true, 0, Low[0] - TickSize, Brushes.HotPink);
				}
			}
			
			
			
			if (MomentumTS[0] > 0 && MomentumTS[0] > MomentumTS[1])
				PlotBrushes[0][0] = MomLongStrongColor;
			else if (MomentumTS[0] > 0 && MomentumTS[0] < MomentumTS[1])
				PlotBrushes[0][0] = MomLongWeakColor;
			
			if (MomentumTS[0] < 0 && MomentumTS[0] < MomentumTS[1])
				PlotBrushes[0][0] = MomShortStrongColor;
			else if (MomentumTS[0] < 0 && MomentumTS[0] > MomentumTS[1])
				PlotBrushes[0][0] = MomShortWeakColor;
		}
		
		#region Plots
		
		[Browsable(false)]
		[XmlIgnore]
		public Series<double> MomentumTS
		{
		  get { return Values[0]; }
		}
		
		[Browsable(false)]
		[XmlIgnore]
		public Series<double> Squeeze
		{
		  get { return Values[1]; }
		}
		
		[Browsable(false)]
		[XmlIgnore]
		public Series<double> BuilderSignal
		{
		  get { return Values[2]; }
		}
		
		#endregion
		
		
		[NinjaScriptProperty]
		[Range(1, double.MaxValue)]
		[Display(Name="Bollinger Deviation", Description="", Order=1, GroupName="1. Parameters")]
		public double BollingerDeviation
		{ get; set; }
		
		[NinjaScriptProperty]
		[Range(1, int.MaxValue)]
		[Display(Name="Bollinger Period", Description="", Order=2, GroupName="1. Parameters")]
		public int BollingerPeriod
		{ get; set; }
		
		[NinjaScriptProperty]
		[Range(1, double.MaxValue)]
		[Display(Name="Keltner Multiplier", Description="", Order=3, GroupName="1. Parameters")]
		public double KeltnerMultiplier
		{ get; set; }
		
		[NinjaScriptProperty]
		[Range(1, int.MaxValue)]
		[Display(Name="Keltner Period", Description="", Order=4, GroupName="1. Parameters")]
		public int KeltnerPeriod
		{ get; set; }
		
		
		[NinjaScriptProperty]
		[Range(1, int.MaxValue)]
		[Display(Name="Momentum Period", Description="", Order=5, GroupName="1. Parameters")]
		public int MomentumPeriod
		{ get; set; }
		
		[NinjaScriptProperty]
		[Range(1, int.MaxValue)]
		[Display(Name="Momentum EMA Period", Description="", Order=6, GroupName="1. Parameters")]
		public int MomentumEMAPeriod
		{ get; set; }
		
		
		
		[XmlIgnore()]
		[Display(Name = "Breakout Color", GroupName = "1. Parameters", Order = 7)]
		public Brush BreakoutColor
		{ get; set; }
		
		// Serialize our Color object
		[Browsable(false)]
		public string BreakoutColorColorSerialize
		{
			get { return Serialize.BrushToString(BreakoutColor); }
   			set { BreakoutColor = Serialize.StringToBrush(value); }
		}
		
		
		[XmlIgnore()]
		[Display(Name = "Momentum Long Strong", GroupName = "1. Parameters", Order = 8)]
		public Brush MomLongStrongColor
		{ get; set; }
		
		// Serialize our Color object
		[Browsable(false)]
		public string MomLongStrongColorSerialize
		{
			get { return Serialize.BrushToString(MomLongStrongColor); }
   			set { MomLongStrongColor = Serialize.StringToBrush(value); }
		}
		
		[XmlIgnore()]
		[Display(Name = "Momentum Long Weak", GroupName = "1. Parameters", Order = 9)]
		public Brush MomLongWeakColor
		{ get; set; }
		
		// Serialize our Color object
		[Browsable(false)]
		public string MomLongWeakColorSerialize
		{
			get { return Serialize.BrushToString(MomLongWeakColor); }
   			set { MomLongWeakColor = Serialize.StringToBrush(value); }
		}
		
		
		[XmlIgnore()]
		[Display(Name = "Momentum Short Strong", GroupName = "1. Parameters", Order = 10)]
		public Brush MomShortStrongColor
		{ get; set; }
		
		// Serialize our Color object
		[Browsable(false)]
		public string MomShortStrongColorSerialize
		{
			get { return Serialize.BrushToString(MomShortStrongColor); }
   			set { MomShortStrongColor = Serialize.StringToBrush(value); }
		}
		
		[XmlIgnore()]
		[Display(Name = "Momentum Short Weak", GroupName = "1. Parameters", Order = 11)]
		public Brush MomShortWeakColor
		{ get; set; }
		
		// Serialize our Color object
		[Browsable(false)]
		public string MomShortWeakColorSerialize
		{
			get { return Serialize.BrushToString(MomShortWeakColor); }
   			set { MomShortWeakColor = Serialize.StringToBrush(value); }
		}
		
		
		[NinjaScriptProperty]
		[Display(Name="Show ENTRY PredatorX Signals", Description="Signals to Automate this indicator with the Predator X Order Entry", Order=0, GroupName="Predator Signals")]
		public bool ShowEntrySignals
		{ get; set; }
		
		[NinjaScriptProperty]
		[Display(Name="Long Entry", Description="Signals to Automate this indicator with the Predator X Order Entry", Order=1, GroupName="Predator Signals")]
		public string LongEntry
		{ get; set; }
		
		[NinjaScriptProperty]
		[Display(Name="Short Entry", Description="Signals to Automate this indicator with the Predator X Order Entry", Order=2, GroupName="Predator Signals")]
		public string ShortEntry
		{ get; set; }
		
		[NinjaScriptProperty]
		[Display(Name="Show Exit PredatorX Signals", Description="Signals to Automate this indicator with the Predator X Order Exit", Order=3, GroupName="Predator Signals")]
		public bool ShowExitSignals
		{ get; set; }
		
		[NinjaScriptProperty]
		[Display(Name="Long Exit", Description="Signals to Automate this indicator with the Predator X Order Exit", Order=4, GroupName="Predator Signals")]
		public string LongExit
		{ get; set; }
		
		[NinjaScriptProperty]
		[Display(Name="Short Exit", Description="Signals to Automate this indicator with the Predator X Order Exit", Order=5, GroupName="Predator Signals")]
		public string ShortExit
		{ get; set; }
		
		#region  TradeSaber Socials
	
		
		[NinjaScriptProperty]
		[Display(Name="Show Social Media Buttons", Description="", Order=1, GroupName="TradeSaber Socials")]
		public bool ShowSocials
		{ get; set; }
		
		[ReadOnly(true)]
		[NinjaScriptProperty]
		[Display(Name="Author", Description="", Order=2, GroupName="TradeSaber Socials")]
		public string Author
		{ get; set; }
		
		[ReadOnly(true)]
		[NinjaScriptProperty]
		[Display(Name="Version", Description="", Order=3, GroupName="TradeSaber Socials")]
		public string Version
		{ get; set; }
		
		[ReadOnly(true)]
		[NinjaScriptProperty]
		[Display(Name="TradeSaber Link", Description="", Order=4, GroupName="TradeSaber Socials")]
		public string TradeSaber
		{ get; set; }
		
		[ReadOnly(true)]
		[NinjaScriptProperty]
		[Display(Name="Discord", Description="", Order=5, GroupName="TradeSaber Socials")]
		public string Discord
		{ get; set; }
		
		[ReadOnly(true)]
		[NinjaScriptProperty]
		[Display(Name="Youtube", Description="", Order=6, GroupName="TradeSaber Socials")]
		public string YouTube
		{ get; set; }
		
		#endregion
	}
}

#region NinjaScript generated code. Neither change nor remove.

namespace NinjaTrader.NinjaScript.Indicators
{
	public partial class Indicator : NinjaTrader.Gui.NinjaScript.IndicatorRenderBase
	{
		private TradeSaber.TTMSqueezeTradeSaber[] cacheTTMSqueezeTradeSaber;
		public TradeSaber.TTMSqueezeTradeSaber TTMSqueezeTradeSaber(double bollingerDeviation, int bollingerPeriod, double keltnerMultiplier, int keltnerPeriod, int momentumPeriod, int momentumEMAPeriod, bool showEntrySignals, string longEntry, string shortEntry, bool showExitSignals, string longExit, string shortExit, bool showSocials, string author, string version, string tradeSaber, string discord, string youTube)
		{
			return TTMSqueezeTradeSaber(Input, bollingerDeviation, bollingerPeriod, keltnerMultiplier, keltnerPeriod, momentumPeriod, momentumEMAPeriod, showEntrySignals, longEntry, shortEntry, showExitSignals, longExit, shortExit, showSocials, author, version, tradeSaber, discord, youTube);
		}

		public TradeSaber.TTMSqueezeTradeSaber TTMSqueezeTradeSaber(ISeries<double> input, double bollingerDeviation, int bollingerPeriod, double keltnerMultiplier, int keltnerPeriod, int momentumPeriod, int momentumEMAPeriod, bool showEntrySignals, string longEntry, string shortEntry, bool showExitSignals, string longExit, string shortExit, bool showSocials, string author, string version, string tradeSaber, string discord, string youTube)
		{
			if (cacheTTMSqueezeTradeSaber != null)
				for (int idx = 0; idx < cacheTTMSqueezeTradeSaber.Length; idx++)
					if (cacheTTMSqueezeTradeSaber[idx] != null && cacheTTMSqueezeTradeSaber[idx].BollingerDeviation == bollingerDeviation && cacheTTMSqueezeTradeSaber[idx].BollingerPeriod == bollingerPeriod && cacheTTMSqueezeTradeSaber[idx].KeltnerMultiplier == keltnerMultiplier && cacheTTMSqueezeTradeSaber[idx].KeltnerPeriod == keltnerPeriod && cacheTTMSqueezeTradeSaber[idx].MomentumPeriod == momentumPeriod && cacheTTMSqueezeTradeSaber[idx].MomentumEMAPeriod == momentumEMAPeriod && cacheTTMSqueezeTradeSaber[idx].ShowEntrySignals == showEntrySignals && cacheTTMSqueezeTradeSaber[idx].LongEntry == longEntry && cacheTTMSqueezeTradeSaber[idx].ShortEntry == shortEntry && cacheTTMSqueezeTradeSaber[idx].ShowExitSignals == showExitSignals && cacheTTMSqueezeTradeSaber[idx].LongExit == longExit && cacheTTMSqueezeTradeSaber[idx].ShortExit == shortExit && cacheTTMSqueezeTradeSaber[idx].ShowSocials == showSocials && cacheTTMSqueezeTradeSaber[idx].Author == author && cacheTTMSqueezeTradeSaber[idx].Version == version && cacheTTMSqueezeTradeSaber[idx].TradeSaber == tradeSaber && cacheTTMSqueezeTradeSaber[idx].Discord == discord && cacheTTMSqueezeTradeSaber[idx].YouTube == youTube && cacheTTMSqueezeTradeSaber[idx].EqualsInput(input))
						return cacheTTMSqueezeTradeSaber[idx];
			return CacheIndicator<TradeSaber.TTMSqueezeTradeSaber>(new TradeSaber.TTMSqueezeTradeSaber(){ BollingerDeviation = bollingerDeviation, BollingerPeriod = bollingerPeriod, KeltnerMultiplier = keltnerMultiplier, KeltnerPeriod = keltnerPeriod, MomentumPeriod = momentumPeriod, MomentumEMAPeriod = momentumEMAPeriod, ShowEntrySignals = showEntrySignals, LongEntry = longEntry, ShortEntry = shortEntry, ShowExitSignals = showExitSignals, LongExit = longExit, ShortExit = shortExit, ShowSocials = showSocials, Author = author, Version = version, TradeSaber = tradeSaber, Discord = discord, YouTube = youTube }, input, ref cacheTTMSqueezeTradeSaber);
		}
	}
}

namespace NinjaTrader.NinjaScript.MarketAnalyzerColumns
{
	public partial class MarketAnalyzerColumn : MarketAnalyzerColumnBase
	{
		public Indicators.TradeSaber.TTMSqueezeTradeSaber TTMSqueezeTradeSaber(double bollingerDeviation, int bollingerPeriod, double keltnerMultiplier, int keltnerPeriod, int momentumPeriod, int momentumEMAPeriod, bool showEntrySignals, string longEntry, string shortEntry, bool showExitSignals, string longExit, string shortExit, bool showSocials, string author, string version, string tradeSaber, string discord, string youTube)
		{
			return indicator.TTMSqueezeTradeSaber(Input, bollingerDeviation, bollingerPeriod, keltnerMultiplier, keltnerPeriod, momentumPeriod, momentumEMAPeriod, showEntrySignals, longEntry, shortEntry, showExitSignals, longExit, shortExit, showSocials, author, version, tradeSaber, discord, youTube);
		}

		public Indicators.TradeSaber.TTMSqueezeTradeSaber TTMSqueezeTradeSaber(ISeries<double> input , double bollingerDeviation, int bollingerPeriod, double keltnerMultiplier, int keltnerPeriod, int momentumPeriod, int momentumEMAPeriod, bool showEntrySignals, string longEntry, string shortEntry, bool showExitSignals, string longExit, string shortExit, bool showSocials, string author, string version, string tradeSaber, string discord, string youTube)
		{
			return indicator.TTMSqueezeTradeSaber(input, bollingerDeviation, bollingerPeriod, keltnerMultiplier, keltnerPeriod, momentumPeriod, momentumEMAPeriod, showEntrySignals, longEntry, shortEntry, showExitSignals, longExit, shortExit, showSocials, author, version, tradeSaber, discord, youTube);
		}
	}
}

namespace NinjaTrader.NinjaScript.Strategies
{
	public partial class Strategy : NinjaTrader.Gui.NinjaScript.StrategyRenderBase
	{
		public Indicators.TradeSaber.TTMSqueezeTradeSaber TTMSqueezeTradeSaber(double bollingerDeviation, int bollingerPeriod, double keltnerMultiplier, int keltnerPeriod, int momentumPeriod, int momentumEMAPeriod, bool showEntrySignals, string longEntry, string shortEntry, bool showExitSignals, string longExit, string shortExit, bool showSocials, string author, string version, string tradeSaber, string discord, string youTube)
		{
			return indicator.TTMSqueezeTradeSaber(Input, bollingerDeviation, bollingerPeriod, keltnerMultiplier, keltnerPeriod, momentumPeriod, momentumEMAPeriod, showEntrySignals, longEntry, shortEntry, showExitSignals, longExit, shortExit, showSocials, author, version, tradeSaber, discord, youTube);
		}

		public Indicators.TradeSaber.TTMSqueezeTradeSaber TTMSqueezeTradeSaber(ISeries<double> input , double bollingerDeviation, int bollingerPeriod, double keltnerMultiplier, int keltnerPeriod, int momentumPeriod, int momentumEMAPeriod, bool showEntrySignals, string longEntry, string shortEntry, bool showExitSignals, string longExit, string shortExit, bool showSocials, string author, string version, string tradeSaber, string discord, string youTube)
		{
			return indicator.TTMSqueezeTradeSaber(input, bollingerDeviation, bollingerPeriod, keltnerMultiplier, keltnerPeriod, momentumPeriod, momentumEMAPeriod, showEntrySignals, longEntry, shortEntry, showExitSignals, longExit, shortExit, showSocials, author, version, tradeSaber, discord, youTube);
		}
	}
}

#endregion
